unit DIAG8061p;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, clipbrd;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Label1: TLabel;
    Button2: TButton;
    Label2: TLabel;
    Button4: TButton;
    Label3: TLabel;
    Button5: TButton;
    Edit1: TEdit;
    Label4: TLabel;
    Button7: TButton;
    Button8: TButton;
    Button10: TButton;
    Label6: TLabel;
    Label8: TLabel;
    Button11: TButton;
    Label7: TLabel;
    Timer1: TTimer;
    Label19: TLabel;
    Label20: TLabel;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure Button7Click(Sender: TObject);
    procedure Button8Click(Sender: TObject);
    procedure Button10Click(Sender: TObject);
    procedure Button11Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Timer1Timer(Sender: TObject);

  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  Buffer: array[0..100] of longint;
  cardnumber: longint;

implementation

{$R *.DFM}
function OpenDevice: Longint; stdcall; external 'K8061.dll';
procedure CloseDevices; stdcall; external 'K8061.dll';

function ReadAnalogChannel(CardAddress: Longint; Channel: Longint):Longint; stdcall; external 'K8061.dll';
procedure ReadAllAnalog(CardAddress: Longint; Buffer: Pointer); stdcall; external 'K8061.dll';
function ReadAllDigital(CardAddress: Longint): Longint; stdcall; external 'K8061.dll';
procedure OutputAnalogChannel(CardAddress: Longint; Channel: Longint; Data: Longint); stdcall; external 'K8061.dll';

procedure OutputAllAnalog(CardAddress: Longint; Buffer: Pointer); stdcall; external 'K8061.dll';
procedure OutputAllDigital(CardAddress: Longint; Data: Longint);stdcall;  external 'K8061.dll';
procedure ClearAllDigital(CardAddress: Longint); stdcall; external 'K8061.dll';
procedure SetDigitalChannel(CardAddress: Longint; Channel: Longint); stdcall; external 'K8061.dll';
procedure SetAllDigital(CardAddress: Longint); stdcall; external 'K8061.dll';
procedure ReadVersion(CardAddress: Longint; Buffer: Pointer); stdcall; external 'K8061.dll';
function PowerGood(CardAddress: Longint): Boolean; stdcall; external 'K8061.dll';
function Connected(CardAddress: Longint): Boolean; stdcall; external 'K8061.dll';

procedure TForm1.Button1Click(Sender: TObject);
var i:integer;
begin
  label1.caption:='- - -';
  label1.update;
  i:=OpenDevice;
  case i of
    0..7: begin
            label1.caption:='Card '+ inttostr(i)+' connected';
            cardnumber:=i;
            Timer1.enabled:=true;
          end;
    -1: label1.caption:='Card '+ inttostr(cardnumber)+' connected';
    -2: label1.caption:='Card not found.';
  end;
end;

procedure TForm1.Button2Click(Sender: TObject);
var i:integer;
begin
  ReadAllAnalog(cardnumber,@Buffer[0]);
  label2.caption:='';
  for i:=0 to 7 do label2.caption:=label2.caption+' '+inttostr(buffer[i]);
end;

procedure TForm1.Button4Click(Sender: TObject);
var i:longint;
begin
  i:=ReadAllDigital(cardnumber);
  label3.caption:=inttostr(i);
end;

procedure TForm1.Button5Click(Sender: TObject);
var n:longint;
begin
  n:=ReadAnalogChannel(cardnumber,strtoint(edit1.text));
  label4.caption:=inttostr(n);
end;

procedure TForm1.Button7Click(Sender: TObject);
begin
  SetAllDigital(cardnumber);
end;

procedure TForm1.Button8Click(Sender: TObject);
begin
  ClearAllDigital(cardnumber);
end;

procedure TForm1.Button10Click(Sender: TObject);
var i:integer;
begin
  ReadVersion(cardnumber,@Buffer[0]);
  label6.caption:='';
  label7.caption:='';
  for i:=0 to 23 do label6.caption:=label6.caption+chr(Buffer[i]);
  for i:=26 to 49 do label7.caption:=label7.caption+chr(Buffer[i]);
end;

procedure TForm1.Button11Click(Sender: TObject);
var i:integer;
begin
  for i:=0 to 7 do Buffer[i]:=10+20*i;
  OutputAllAnalog(cardnumber, @Buffer);
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  CloseDevices;
end;

procedure TForm1.Timer1Timer(Sender: TObject);
begin
    if PowerGood(cardnumber) then
  begin
    Label19.Caption:='CPU OK';
    Label19.Font.Color:=$8000;
  end
  else
  begin
    Label19.Caption:='CPU FAIL';
    Label19.Font.Color:=ClRed;
  end;
   if Connected(cardnumber) then
  begin
    Label20.Caption:='USB Connected';
    Label20.Font.Color:=$8000;
  end
  else
  begin
    Label20.Caption:='USB Disconnected';
    Label20.Font.Color:=ClRed;
    Label1.Caption:='Card disconnected';
  end;
end;

end.
