﻿Public Class Form1
    Dim Number As Integer
    Dim n As Integer
    Dim CardAddress As Integer
    Private Declare Function OpenDevice Lib "k8061.dll" () As Integer
    Private Declare Sub CloseDevices Lib "k8061.dll" ()
    Private Declare Sub CloseDevice Lib "k8061.dll" (ByVal CardAddress As Integer)
    Private Declare Function PowerGood Lib "k8061.dll" (ByVal CardAddress As Integer) As Boolean
    Private Declare Function Connected Lib "k8061.dll" (ByVal CardAddress As Integer) As Boolean
    Private Declare Function ReadAnalogChannel Lib "k8061.dll" (ByVal CardAddress As Integer, ByVal Channel As Integer) As Integer
    Private Declare Sub ReadAllAnalog Lib "k8061.dll" (ByVal CardAddress As Integer, ByRef Buffer As Integer)

    Private Declare Sub ReadCounters Lib "k8061.dll" (ByVal CardAddress As Integer, ByRef Buffer As Integer)
    Private Declare Sub ResetCounters Lib "k8061.dll" (ByVal CardAddress As Integer)

    Private Declare Sub OutputAnalogChannel Lib "k8061.dll" (ByVal CardAddress As Integer, ByVal Channel As Integer, ByVal Data As Integer)
    Private Declare Sub OutputAllAnalog Lib "k8061.dll" (ByVal CardAddress As Integer, ByRef Buffer As Integer)
    Private Declare Sub ClearAnalogChannel Lib "k8061.dll" (ByVal CardAddress As Integer, ByVal Channel As Integer)
    Private Declare Sub SetAllAnalog Lib "k8061.dll" (ByVal CardAddress As Integer)
    Private Declare Sub ClearAllAnalog Lib "k8061.dll" (ByVal CardAddress As Integer)
    Private Declare Sub SetAnalogChannel Lib "k8061.dll" (ByVal CardAddress As Integer, ByVal Channel As Integer)
    Private Declare Sub OutputAllDigital Lib "k8061.dll" (ByVal CardAddress As Integer, ByVal Data As Integer)
    Private Declare Sub ClearDigitalChannel Lib "k8061.dll" (ByVal CardAddress As Integer, ByVal Channel As Integer)
    Private Declare Sub ClearAllDigital Lib "k8061.dll" (ByVal CardAddress As Integer)
    Private Declare Sub SetDigitalChannel Lib "k8061.dll" (ByVal CardAddress As Integer, ByVal Channel As Integer)
    Private Declare Sub SetAllDigital Lib "k8061.dll" (ByVal CardAddress As Integer)
    Private Declare Function ReadDigitalChannel Lib "k8061.dll" (ByVal CardAddress As Integer, ByVal Channel As Integer) As Boolean
    Private Declare Function ReadAllDigital Lib "k8061.dll" (ByVal CardAddress As Integer) As Integer
    Private Declare Sub OutputPWM Lib "k8061.dll" (ByVal CardAddress As Integer, ByVal Data As Integer)
    Private Declare Function ReadBackDigitalOut Lib "k8061.dll" (ByVal CardAddress As Integer) As Integer
    Private Declare Sub ReadBackAnalogOut Lib "k8061.dll" (ByVal CardAddress As Integer, ByRef Buffer As Integer)
    Private Declare Function ReadBackPWMOut Lib "k8061.dll" (ByVal CardAddress As Integer) As Integer

    Private Sub Button1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button1.Click
        Dim h As Integer
        h = OpenDevice()
        Select Case h
            Case 0, 1, 2, 3, 4, 5, 6, 7
                Label1.Text = "Card " + Str(h) + " connected."
                CardAddress = h
                Timer1.Enabled = True
            Case -1
                Label1.Text = "All cards connected."
            Case -2
                Label1.Text = "Card not found."
        End Select
        Select Case h
            Case 0
                RadioButton1.Enabled = True
                RadioButton1.Checked = True
            Case 1
                RadioButton2.Enabled = True
                RadioButton2.Checked = True
            Case 2
                RadioButton3.Enabled = True
                RadioButton3.Checked = True
            Case 3
                RadioButton4.Enabled = True
                RadioButton4.Checked = True
            Case 4
                RadioButton5.Enabled = True
                RadioButton5.Checked = True
            Case 5
                RadioButton6.Enabled = True
                RadioButton6.Checked = True
            Case 6
                RadioButton7.Enabled = True
                RadioButton7.Checked = True
            Case 7
                RadioButton8.Enabled = True
                RadioButton8.Checked = True
        End Select
    End Sub

    Private Sub Form1_FormClosed(ByVal sender As System.Object, ByVal e As System.Windows.Forms.FormClosedEventArgs) Handles MyBase.FormClosed
        CloseDevices()
    End Sub

    Private Sub Timer1_Tick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Timer1.Tick
        Dim i As Integer
        Dim Buffer(8) As Integer
        Timer1.Enabled = False
        If PowerGood(CardAddress) Then
            Label20.Text = "CPU OK"
        Else
            Label20.Text = "CPU FAIL"
        End If
        If Connected(CardAddress) Then
            Label21.Text = "USB Connected"
        Else
            Label21.Text = "USB Disconnected"
            Label1.Text = "Card disconnected"
        End If
        i = ReadAllDigital(CardAddress)
        CheckBox1.Checked = (i And 1) > 0
        CheckBox2.Checked = (i And 2) > 0
        CheckBox3.Checked = (i And 4) > 0
        CheckBox4.Checked = (i And 8) > 0
        CheckBox5.Checked = (i And 16) > 0
        CheckBox6.Checked = (i And 32) > 0
        CheckBox7.Checked = (i And 64) > 0
        CheckBox8.Checked = (i And 128) > 0

        ReadAllAnalog(CardAddress, Buffer(0))
        ProgressBar1.Value = Buffer(0)
        Label2.Text = CStr(Buffer(0))
        ProgressBar2.Value = Buffer(1)
        Label3.Text = CStr(Buffer(1))
        ProgressBar3.Value = Buffer(2)
        Label4.Text = CStr(Buffer(2))
        ProgressBar4.Value = Buffer(3)
        Label5.Text = CStr(Buffer(3))
        ProgressBar5.Value = Buffer(4)
        Label6.Text = CStr(Buffer(4))
        ProgressBar6.Value = Buffer(5)
        Label7.Text = CStr(Buffer(5))
        ProgressBar7.Value = Buffer(6)
        Label8.Text = CStr(Buffer(6))
        ProgressBar8.Value = Buffer(7)
        Label9.Text = CStr(Buffer(7))
        Timer1.Enabled = True
    End Sub

    Private Sub Timer2_Tick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Timer2.Tick
        ClearDigitalChannel(CardAddress, n)
        n = n + 1
        If n = 9 Then n = 1
        SetDigitalChannel(CardAddress, n)
    End Sub

    Private Sub Button4_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button4.Click
        SetAllDigital(CardAddress)
        CheckBox9.Checked = True
        CheckBox10.Checked = True
        CheckBox11.Checked = True
        CheckBox12.Checked = True
        CheckBox13.Checked = True
        CheckBox14.Checked = True
        CheckBox15.Checked = True
        CheckBox16.Checked = True
    End Sub

    Private Sub Button5_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button5.Click
        ClearAllDigital(CardAddress)
        CheckBox9.Checked = False
        CheckBox10.Checked = False
        CheckBox11.Checked = False
        CheckBox12.Checked = False
        CheckBox13.Checked = False
        CheckBox14.Checked = False
        CheckBox15.Checked = False
        CheckBox16.Checked = False
    End Sub

    Private Sub Button7_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button7.Click
        SetAllAnalog(CardAddress)
        HScrollBar1.Value = 255
        HScrollBar2.Value = 255
        HScrollBar3.Value = 255
        HScrollBar4.Value = 255
        HScrollBar5.Value = 255
        HScrollBar6.Value = 255
        HScrollBar7.Value = 255
        HScrollBar8.Value = 255
        Label10.Text = "255"
        Label11.Text = "255"
        Label12.Text = "255"
        Label13.Text = "255"
        Label14.Text = "255"
        Label15.Text = "255"
        Label16.Text = "255"
        Label17.Text = "255"
    End Sub

    Private Sub Button6_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button6.Click
        ClearAllAnalog(CardAddress)
        HScrollBar1.Value = 0
        HScrollBar2.Value = 0
        HScrollBar3.Value = 0
        HScrollBar4.Value = 0
        HScrollBar5.Value = 0
        HScrollBar6.Value = 0
        HScrollBar7.Value = 0
        HScrollBar8.Value = 0
        Label10.Text = "0"
        Label11.Text = "0"
        Label12.Text = "0"
        Label13.Text = "0"
        Label14.Text = "0"
        Label15.Text = "0"
        Label16.Text = "0"
        Label17.Text = "0"
    End Sub

    Private Sub CheckBox30_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles CheckBox30.CheckedChanged
        If CheckBox30.Checked Then
            Timer2.Enabled = True
        Else
            Timer2.Enabled = False
            CheckBox9.Checked = False
            CheckBox10.Checked = False
            CheckBox11.Checked = False
            CheckBox12.Checked = False
            CheckBox13.Checked = False
            CheckBox14.Checked = False
            CheckBox15.Checked = False
            CheckBox16.Checked = False
        End If
    End Sub

    Private Sub Button3_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button3.Click
        Dim DigitalOut As Integer
        Dim AnalogOut(0 To 7) As Integer
        DigitalOut = ReadBackDigitalOut(CardAddress)
        CheckBox9.Checked = False
        CheckBox10.Checked = False
        CheckBox11.Checked = False
        CheckBox12.Checked = False
        CheckBox13.Checked = False
        CheckBox14.Checked = False
        CheckBox15.Checked = False
        CheckBox16.Checked = False
        If (DigitalOut And 1) > 0 Then CheckBox9.Checked = True
        If (DigitalOut And 2) > 0 Then CheckBox10.Checked = True
        If (DigitalOut And 4) > 0 Then CheckBox11.Checked = True
        If (DigitalOut And 8) > 0 Then CheckBox12.Checked = True
        If (DigitalOut And 16) > 0 Then CheckBox13.Checked = True
        If (DigitalOut And 32) > 0 Then CheckBox14.Checked = True
        If (DigitalOut And 64) > 0 Then CheckBox15.Checked = True
        If (DigitalOut And 128) > 0 Then CheckBox16.Checked = True

        ReadBackAnalogOut(CardAddress, AnalogOut(0))
        HScrollBar1.Value = AnalogOut(0)
        HScrollBar2.Value = AnalogOut(1)
        HScrollBar3.Value = AnalogOut(2)
        HScrollBar4.Value = AnalogOut(3)
        HScrollBar5.Value = AnalogOut(4)
        HScrollBar6.Value = AnalogOut(5)
        HScrollBar7.Value = AnalogOut(6)
        HScrollBar8.Value = AnalogOut(7)

        HScrollBar9.Value = ReadBackPWMOut(CardAddress)
    End Sub

    Private Sub Button2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button2.Click
        CloseDevices()
        Label1.Text = "Card disconnected."
        Label20.Text = "- - -"
        Label21.Text = "- - -"
        Timer1.Enabled = False
        Timer2.Enabled = False
    End Sub

    Private Sub HScrollBar1_Scroll(ByVal sender As System.Object, ByVal e As System.Windows.Forms.ScrollEventArgs) Handles HScrollBar1.Scroll
        Label10.Text = CStr(HScrollBar1.Value)
        OutputAnalogChannel(CardAddress, 1, HScrollBar1.Value)
    End Sub

    Private Sub HScrollBar2_Scroll(ByVal sender As System.Object, ByVal e As System.Windows.Forms.ScrollEventArgs) Handles HScrollBar2.Scroll
        Label11.Text = CStr(HScrollBar2.Value)
        OutputAnalogChannel(CardAddress, 2, HScrollBar2.Value)
    End Sub

    Private Sub HScrollBar3_Scroll(ByVal sender As System.Object, ByVal e As System.Windows.Forms.ScrollEventArgs) Handles HScrollBar3.Scroll
        Label12.Text = CStr(HScrollBar3.Value)
        OutputAnalogChannel(CardAddress, 3, HScrollBar3.Value)
    End Sub

    Private Sub HScrollBar4_Scroll(ByVal sender As System.Object, ByVal e As System.Windows.Forms.ScrollEventArgs) Handles HScrollBar4.Scroll
        Label13.Text = CStr(HScrollBar4.Value)
        OutputAnalogChannel(CardAddress, 4, HScrollBar4.Value)
    End Sub

    Private Sub HScrollBar5_Scroll(ByVal sender As System.Object, ByVal e As System.Windows.Forms.ScrollEventArgs) Handles HScrollBar5.Scroll
        Label14.Text = CStr(HScrollBar5.Value)
        OutputAnalogChannel(CardAddress, 5, HScrollBar5.Value)
    End Sub

    Private Sub HScrollBar6_Scroll(ByVal sender As System.Object, ByVal e As System.Windows.Forms.ScrollEventArgs) Handles HScrollBar6.Scroll
        Label15.Text = CStr(HScrollBar6.Value)
        OutputAnalogChannel(CardAddress, 6, HScrollBar6.Value)
    End Sub

    Private Sub HScrollBar7_Scroll(ByVal sender As System.Object, ByVal e As System.Windows.Forms.ScrollEventArgs) Handles HScrollBar7.Scroll
        Label16.Text = CStr(HScrollBar7.Value)
        OutputAnalogChannel(CardAddress, 7, HScrollBar7.Value)
    End Sub

    Private Sub HScrollBar8_Scroll(ByVal sender As System.Object, ByVal e As System.Windows.Forms.ScrollEventArgs) Handles HScrollBar8.Scroll
        Label17.Text = CStr(HScrollBar8.Value)
        OutputAnalogChannel(CardAddress, 8, HScrollBar8.Value)
    End Sub

    Private Sub HScrollBar9_Scroll(ByVal sender As System.Object, ByVal e As System.Windows.Forms.ScrollEventArgs) Handles HScrollBar9.Scroll
        Label18.Text = CStr(HScrollBar9.Value)
        OutputPWM(CardAddress, HScrollBar9.Value)
    End Sub

    Private Sub RadioButton1_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles RadioButton1.CheckedChanged
        CardAddress = 0
    End Sub

    Private Sub RadioButton2_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles RadioButton2.CheckedChanged
        CardAddress = 1
    End Sub

    Private Sub RadioButton3_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles RadioButton3.CheckedChanged
        CardAddress = 2
    End Sub

    Private Sub RadioButton4_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles RadioButton4.CheckedChanged
        CardAddress = 3
    End Sub

    Private Sub RadioButton5_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles RadioButton5.CheckedChanged
        CardAddress = 4
    End Sub

    Private Sub RadioButton6_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles RadioButton6.CheckedChanged
        CardAddress = 5
    End Sub

    Private Sub RadioButton7_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles RadioButton7.CheckedChanged
        CardAddress = 6
    End Sub

    Private Sub RadioButton8_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles RadioButton8.CheckedChanged
        CardAddress = 7
    End Sub

    Private Sub CheckBox9_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles CheckBox9.CheckedChanged
        If CheckBox9.Checked Then SetDigitalChannel(CardAddress, 1) Else ClearDigitalChannel(CardAddress, 1)
    End Sub

    Private Sub CheckBox10_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles CheckBox10.CheckedChanged
        If CheckBox10.Checked Then SetDigitalChannel(CardAddress, 2) Else ClearDigitalChannel(CardAddress, 2)
    End Sub

    Private Sub CheckBox11_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles CheckBox11.CheckedChanged
        If CheckBox11.Checked Then SetDigitalChannel(CardAddress, 3) Else ClearDigitalChannel(CardAddress, 3)
    End Sub

    Private Sub CheckBox12_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles CheckBox12.CheckedChanged
        If CheckBox12.Checked Then SetDigitalChannel(CardAddress, 4) Else ClearDigitalChannel(CardAddress, 4)
    End Sub

    Private Sub CheckBox13_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles CheckBox13.CheckedChanged
        If CheckBox13.Checked Then SetDigitalChannel(CardAddress, 5) Else ClearDigitalChannel(CardAddress, 5)
    End Sub

    Private Sub CheckBox14_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles CheckBox14.CheckedChanged
        If CheckBox14.Checked Then SetDigitalChannel(CardAddress, 6) Else ClearDigitalChannel(CardAddress, 6)
    End Sub

    Private Sub CheckBox15_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles CheckBox15.CheckedChanged
        If CheckBox15.Checked Then SetDigitalChannel(CardAddress, 7) Else ClearDigitalChannel(CardAddress, 7)
    End Sub

    Private Sub CheckBox16_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles CheckBox16.CheckedChanged
        If CheckBox16.Checked Then SetDigitalChannel(CardAddress, 8) Else ClearDigitalChannel(CardAddress, 8)
    End Sub
End Class
