//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "Unit1.h"
#include "K8061.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
  bool DisableOtherFunctionCall = false;
  int CardAddr;
  int n=8;
//---------------------------------------------------------------------------

__fastcall TForm1::TForm1(TComponent* Owner)
        : TForm(Owner)
{

}
//---------------------------------------------------------------------------

void __fastcall TForm1::Connect1Click(TObject *Sender)
{
  int h = OpenDevice();
  switch (h) {
    case  0:
    case  1:
    case  2:
    case  3:
    case  4:
    case  5:
    case  6:
    case  7:
      Label1->Caption = "Card " + IntToStr(h) + " connected";
      RadioGroup1->Items->Strings[h] = IntToStr(h);
      RadioGroup1->Enabled = true;
      RadioGroup1->ItemIndex = h;
      Timer1->Enabled = true;
      break;
    case  -1 :
      Label1->Caption = "All cards connected.";
      break;
    case -2 :
      Label1->Caption = "Card not found";
  }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::FormClose(TObject *Sender, TCloseAction &Action)
{
  CloseDevices();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::FormCreate(TObject *Sender)
{
    for (int i=0;i<8;i++)    // Create Output Check Boxes
    {
        op[i] = new TCheckBox(GroupBox7);
        op[i]->Name = "Outbox" + IntToStr(i+1);
        op[i]->Caption = IntToStr(i+1);
        op[i]->Width = 30;
        op[i]->Left = 32 * i + 16;
        op[i]->Top = 18;
        op[i]->Parent = GroupBox7;
        op[i]->OnClick = OutBoxClick;
    }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::SetAllDigital1Click(TObject *Sender)
{
  SetAllDigital(CardAddr);
  DisableOtherFunctionCall = true;
  for (int i=0;i<8;i++)
  {
    op[i]->Checked = true;
  }
  DisableOtherFunctionCall = false;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::OutBoxClick(TObject *Sender)
{
    int k = 0;
    int n = 1;
    for (int i=0;i<8;i++)
    {
      if (op[i]->Checked == true)
      {
        k = k + n;
      }
      n = n * 2;
    }
    if (DisableOtherFunctionCall == false)
      OutputAllDigital(CardAddr, k);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::ClearAllDigital1Click(TObject *Sender)
{
  ClearAllDigital(CardAddr);
  DisableOtherFunctionCall = true;
  for (int i=0;i<8;i++)
  {
    op[i]->Checked = false;
  }
  DisableOtherFunctionCall = false;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::SetAllAnalog1Click(TObject *Sender)
{
  SetAllAnalog(CardAddr);
  DisableOtherFunctionCall = true;
  DAC1->Position = 0;
  DAC2->Position = 0;
  DAC3->Position = 0;
  DAC4->Position = 0;
  DAC5->Position = 0;
  DAC6->Position = 0;
  DAC7->Position = 0;
  DAC8->Position = 0;
  DisableOtherFunctionCall = false;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::ClearAllAnalog1Click(TObject *Sender)
{
  ClearAllAnalog(CardAddr);
  DisableOtherFunctionCall = true;
  DAC1->Position = 255;
  DAC2->Position = 255;
  DAC3->Position = 255;
  DAC4->Position = 255;
  DAC5->Position = 255;
  DAC6->Position = 255;
  DAC7->Position = 255;
  DAC8->Position = 255;
  DisableOtherFunctionCall = false;
}
//---------------------------------------------------------------------------


void __fastcall TForm1::Timer1Timer(TObject *Sender)
{
  Timer1->Enabled = false;
  int Buffer[8];
  int i;
  if (PowerGood(CardAddr))
  {
    Label19->Caption = "CPU OK";
  }
  else
  {
    Label19->Caption = "CPU FAIL";
  }
  if (Connected(CardAddr))
  {
    Label20->Caption = "USB Connected";
  }
  else
  {
    Label20->Caption = "USB Disconnected";
    Label1->Caption = "Card disconnected";
  }
  ReadAllAnalog(CardAddr, Buffer);
  AD1->Position = Buffer[0];
  AD2->Position = Buffer[1];
  AD3->Position = Buffer[2];
  AD4->Position = Buffer[3];
  AD5->Position = Buffer[4];
  AD6->Position = Buffer[5];
  AD7->Position = Buffer[6];
  AD8->Position = Buffer[7];
  Label3->Caption = IntToStr(Buffer[0]);
  Label4->Caption = IntToStr(Buffer[1]);
  Label5->Caption = IntToStr(Buffer[2]);
  Label6->Caption = IntToStr(Buffer[3]);
  Label7->Caption = IntToStr(Buffer[4]);
  Label8->Caption = IntToStr(Buffer[5]);
  Label9->Caption = IntToStr(Buffer[6]);
  Label10->Caption = IntToStr(Buffer[7]);
  i = ReadAllDigital(CardAddr);
  CheckBox3->Checked = (i & 1)>0;
  CheckBox4->Checked = (i & 2)>0;
  CheckBox5->Checked = (i & 4)>0;
  CheckBox6->Checked = (i & 8)>0;
  CheckBox7->Checked = (i & 16)>0;
  CheckBox8->Checked = (i & 32)>0;
  CheckBox9->Checked = (i & 64)>0;
  CheckBox10->Checked = (i & 128)>0;
  Timer1->Enabled = true;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::OutputTest1Click(TObject *Sender)
{
    Timer2->Enabled = OutputTest1->Down;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Timer2Timer(TObject *Sender)
{
  ClearDigitalChannel(CardAddr, n);
  op[n-1]->Checked = false;
  n = n +1;
  if (n == 9)
    n = 1;
  SetDigitalChannel(CardAddr, n);
  op[n-1]->Checked = true;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::DAC1Change(TObject *Sender)
{
  if (DisableOtherFunctionCall == false)
    OutputAnalogChannel(CardAddr, 1, 255-DAC1->Position);
  Label2->Caption = 255 - DAC1->Position;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::DAC2Change(TObject *Sender)
{
  if (DisableOtherFunctionCall == false)
    OutputAnalogChannel(CardAddr, 2, 255-DAC2->Position);
  Label11->Caption = 255 - DAC2->Position;
}

//---------------------------------------------------------------------------

void __fastcall TForm1::DAC3Change(TObject *Sender)
{
  if (DisableOtherFunctionCall == false)
    OutputAnalogChannel(CardAddr, 3, 255-DAC3->Position);
  Label12->Caption = 255 - DAC3->Position;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::DAC4Change(TObject *Sender)
{
  if (DisableOtherFunctionCall == false)
    OutputAnalogChannel(CardAddr, 4, 255-DAC4->Position);
  Label13->Caption = 255 - DAC4->Position;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::DAC5Change(TObject *Sender)
{
  if (DisableOtherFunctionCall == false)
    OutputAnalogChannel(CardAddr, 5, 255-DAC5->Position);
  Label14->Caption = 255 - DAC5->Position;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::DAC6Change(TObject *Sender)
{
  if (DisableOtherFunctionCall == false)
    OutputAnalogChannel(CardAddr, 6, 255-DAC6->Position);
  Label15->Caption = 255 - DAC6->Position;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::DAC7Change(TObject *Sender)
{
  if (DisableOtherFunctionCall == false)
    OutputAnalogChannel(CardAddr, 7, 255-DAC7->Position);
  Label16->Caption = 255 - DAC7->Position;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::DAC8Change(TObject *Sender)
{
  if (DisableOtherFunctionCall == false)
    OutputAnalogChannel(CardAddr, 8, 255-DAC8->Position);
  Label17->Caption = 255 - DAC8->Position;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::TrackBar8Change(TObject *Sender)
{
  OutputPWM(CardAddr, 1023-TrackBar8->Position);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::RadioGroup1Click(TObject *Sender)
{
  
  if(RadioGroup1->Items->Strings[RadioGroup1->ItemIndex] != "- -")
  CardAddr = RadioGroup1->ItemIndex;
  else
  ShowMessage("Card not opened!");
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button1Click(TObject *Sender)
{
  int Info[51];
  int i;
  ReadVersion(CardAddr, Info);
  Label21->Caption = "";
  for(i=0;i<50;i++) Label21->Caption = Label21->Caption+char(Info[i]);
}
//---------------------------------------------------------------------------


